#ifndef LLF_UTILS_H
#define LLF_UTILS_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  LLF_Utils.h
*  State           :  %state%
*  Creation date   :  21.06.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains declarations of low level functions for Utils.
*
*  \version LLF_Utils.h#1:cinc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd. All rights reserved.
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
* LLF_MulNum
*
*  @param Buf1_ptr [in] - A pointer to buffer with first big-endian number;
*  @param Buf1SizeInBits [in] - The size of the first number in bits;
*  @param Buf2_ptr [in] - A pointer to buffer with second big-endian number; 
*  @param Buf2SizeInBits [in] - The size of the second number in bits;
*  @param Res_ptr [out] - A pointer to the buffer with output big-endian number; 
*  @param ResSizeInBytes_ptr [in/out] - The size of the output number in bytes.
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_UTILS_INVALID_POINTER_ERROR
*
* \brief \b 
* Description:
*  This function multiplicate two big number and store result in output buffer;
*
*  \b 
* Algorithm:
*  -# Convert numbers to LibTomCrypt format;
*  -# Make multiplication with using LibTomCrypt; 
*  -# Convert result to output big-endian format.
***************************************************************/
CE2Error_t LLF_MulNum( 
  DxUint32_t *Buf1_ptr, 
  DxUint32_t Buf1SizeInBits,
  DxUint32_t *Buf2_ptr, 
  DxUint32_t Buf2SizeInBits,
  DxUint32_t *Res_ptr, 
  DxUint32_t *ResSizeInBytes_ptr);

/**
****************************************************************
* Function Name: 
* LLF_GetBufferEffectiveSizeInBits
*
*  @param Buffer_ptr [in] - A pointer to buffer with big-endian number;
*  @param BufferSizeInBytes [in] - The size of the buffer;
*  @param EffectiveSizeInBits_ptr [out] - A output pointer with effective 
*                                         size in bits.
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_UTILS_INVALID_POINTER_ERROR
*
* \brief \b 
* Description:
*  Get effective size in bits for given buffer with big number in 
*  big-endian format.
*
*  \b 
* Algorithm:
*  -# Convert number to LibTomCrypt format;
*  -# Getting its effective size in bits with using LibTomCrypt; 
***************************************************************/
CE2Error_t LLF_GetBufferEffectiveSizeInBits(
  DxUint8_t  *Buffer_ptr,
  DxUint16_t BufferSizeInBytes,
  DxUint32_t *EffectiveSizeInBits_ptr);

#ifdef __cplusplus
}
#endif

#endif
